import { Link, useLocation } from 'react-router-dom'
import { Scissors } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-sewing">
      <header className="header-sewing">
        <div className="container">
          <div className="header-content-sewing">
            <Link to="/" className="logo-sewing">
              <div className="logo-icon-wrapper-sewing">
                <Scissors className="logo-icon-sewing" size={32} />
              </div>
              <span className="logo-text-sewing">STITCHCRAFT</span>
            </Link>
            <nav className="nav-sewing">
              <Link 
                to="/" 
                className={`nav-link-sewing ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои курсы
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-sewing ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-sewing">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

